/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.tabbedPane;

import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWTabButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

class VWTabButtonPanel
extends JPanel {
    protected static final int LEFT_OFFSET = 15;
    protected int m_nType = 0;
    protected int m_nRightOffset = 0;

    public VWTabButtonPanel(LayoutManager layout, int nType) {
        super(layout);
        this.m_nType = nType;
    }

    public Component add(Component newComponent) {
        if (this.getComponentCount() == 0) {
            super.add(Box.createHorizontalStrut(15));
            this.m_nRightOffset += 15;
        } else if (this.m_nType == 1) {
            JLabel separator = new JLabel(VWImageLoader.createImageIconNoMessage("tbseparator.gif"));
            super.add(separator);
        }
        if (this.m_nType == 0) {
            Dimension size = newComponent.getPreferredSize();
            this.m_nRightOffset = (int)((double)this.m_nRightOffset + size.getWidth());
        }
        return super.add(newComponent);
    }

    public void remove(Component component) {
        super.remove(component);
        if (this.m_nType == 0) {
            Dimension size = component.getPreferredSize();
            this.m_nRightOffset = (int)((double)this.m_nRightOffset - size.getWidth());
        }
    }

    public void removeAll() {
        super.removeAll();
        this.m_nRightOffset = 0;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Color oldColor = g.getColor();
        switch (this.m_nType) {
            case 0: {
                g.setColor(VWTabButton.COLOR_SELECTED);
                Dimension size = this.getSize();
                if (this.getComponentOrientation().isLeftToRight()) {
                    int nWidth = 14;
                    g.drawLine(0, size.height - 1, nWidth, size.height - 1);
                    g.drawLine(this.m_nRightOffset, size.height - 1, size.width, size.height - 1);
                    g.setColor(VWTabButton.COLOR_NORMAL);
                    g.drawLine(nWidth, size.height - 2, nWidth, 2);
                    break;
                }
                g.drawLine(size.width - 15, size.height - 1, size.width, size.height - 1);
                int nWidth = size.width - this.m_nRightOffset;
                g.drawLine(0, size.height - 1, nWidth, size.height - 1);
                g.setColor(VWTabButton.COLOR_NORMAL);
                g.drawLine(nWidth - 1, size.height - 2, nWidth - 1, 2);
                break;
            }
            case 1: {
                g.setColor(VWTabButton.BGCOLOR_LTGRAY);
                Dimension size = this.getSize();
                g.fillRect(1, size.height - 5, size.width - 1, 2);
                break;
            }
        }
        g.setColor(oldColor);
    }
}

